import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:block_destroy', {
        onPlayerDestroy: (data) => {
            const player = data.player
            const block = data.block
            const spawnItemStack = new ItemStack(data.destroyedBlockPermutation.type.id, 1);
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand');
            const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
            if (isPickaxe && player.getGameMode() !== "creative") {
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:double_block_destroy', {
        onPlayerDestroy: (data) => {
            const player = data.player
            const block = data.block
            const spawnItemStack = new ItemStack(data.destroyedBlockPermutation.type.id, 2);
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand');
            const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
            if (isPickaxe && player.getGameMode() !== "creative") {
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:non_stone_block_destroy', {
        onPlayerDestroy: (data) => {
            const player = data.player
            const block = data.block
            const spawnItemStack = new ItemStack(data.destroyedBlockPermutation.type.id, 1);
            if (player.getGameMode() !== "creative") {
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:non_stone_double_block_destroy', {
        onPlayerDestroy: (data) => {
            const player = data.player
            const block = data.block
            const spawnItemStack = new ItemStack(data.destroyedBlockPermutation.type.id, 2);
            if (player.getGameMode() !== "creative") {
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
        }
    })
})